from Simulation import *
from Tkinter import *
from visual import *

from kSpace import *


nSpinsX = 3
nSpinsY = 2

stripeSpacingX = nSpinsX
stripeSpacingY = nSpinsY

Ja = -1.0
Jbx = 2.0
Jby = -1.0

k = pi*vector(2.0/nSpinsX,0.0,0.0)

baseSigma = .001
dt = .001



class Interface:
    tkr = Tk()

    simu = Simulation(tkr, nSpinsX, nSpinsY, stripeSpacingX, stripeSpacingY, Ja, Jbx, Jby, k, baseSigma, dt)
    kSp = kSpace(tkr)
    
    kxWidget = Scale()
    kyWidget = Scale()


    def __init__(self, nSpinsX, nSpinsY, stripeSpacingX, stripeSpacingY, Ja, Jbx, Jby, k, baseSigma, dt):
        self.k = k

        ##  TKR appearance and widget creation ##
        self.tkr.wm_geometry(newGeometry="400x450+700+20")   
        self.tkr.wm_title("Controls")

        topFrame = Frame(self.tkr,relief=SUNKEN, borderwidth=0)
        topFrame.grid(row=0, column=0, padx=0, pady=0)

        toggleFrame = Frame(topFrame, relief=FLAT, borderwidth=0)
        toggleFrame.grid(row=0, column=0, padx=4, pady=4)

        ####
        visualSphereFrame = Frame(toggleFrame, relief=FLAT, borderwidth=1)
        visualSphereFrame.grid(row=0, column=0, padx=4, pady=4)

        #
        modesLabel = Label(visualSphereFrame, text="Visual Sphere Options:").grid(row=0, column=0, sticky=W)

        tracersLabel = Label(visualSphereFrame, text="Tracers").grid(row=1, column=0, sticky=E)
        tracersWidget = Checkbutton(visualSphereFrame, text="", variable=self.simu.toggleTracersVar, command=self.simu.toggleTracers)
        tracersWidget.grid(row=1, column=1)

        pointsLabel = Label(visualSphereFrame, text="Points").grid(row=2, column=0, sticky=E)
        pointsWidget = Checkbutton(visualSphereFrame, text="", variable=self.simu.togglePointsVar, command=self.simu.togglePoints)
        pointsWidget.grid(row=2, column=1)

        vectorsLabel = Label(visualSphereFrame, text="Vectors").grid(row=3, column=0, sticky=E)
        vectorsWidget = Checkbutton(visualSphereFrame, text="", variable=self.simu.toggleSphereVectorsVar, command=self.simu.toggleVectors)
        vectorsWidget.grid(row=3, column=1)


        axisDisplayLabel = Label(visualSphereFrame, text="Display Axis").grid(row=1, column=2, sticky=E)
        axisDisplayWidget = Checkbutton(visualSphereFrame, text="", variable=self.simu.toggleAxisVar, command=self.simu.toggleAxis)
        axisDisplayWidget.grid(row=1, column=3)

        axisSyncLabel = Label(visualSphereFrame, text="Sync View Axis").grid(row=2, column=2, sticky=E)
        axisSyncWidget = Checkbutton(visualSphereFrame, text="", variable=self.simu.toggleAxisSyncVar, command=self.simu.toggleAxisSync)
        axisSyncWidget.grid(row=2, column=3)

        UCvectorsLabel = Label(visualSphereFrame, text="UC Vectors").grid(row=3, column=2, sticky=E)
        UCvectorsWidget = Checkbutton(visualSphereFrame, text="", variable=self.simu.toggleUCVectorsVar, command=self.simu.toggleUCVectors)
        UCvectorsWidget.grid(row=3, column=3)


        phasePointsLabel = Label(visualSphereFrame, text="Phase Points").grid(row=1, column=4, sticky=E)
        phasePointsWidget = Checkbutton(visualSphereFrame, text="", variable=self.simu.togglePhasePointsVar, command=self.simu.togglePhasePoints)
        phasePointsWidget.grid(row=1, column=5)

        anglePlotLabel = Label(visualSphereFrame, text="Angle Plot").grid(row=2, column=4, sticky=E)
        anglePlotWidget = Checkbutton(visualSphereFrame, text="", variable=self.simu.toggleAnglePlotVar, command=self.simu.toggleAnglePlot)
        anglePlotWidget.grid(row=2, column=5)
        #

        ####
        simuFrame = Frame(toggleFrame, relief=FLAT, borderwidth=0)
        simuFrame.grid(row=1, column=0, columnspan=2, padx=4, pady=4)
        #
        simuLabel = Label(simuFrame, text="Simulation:").grid(row=0, column=0, sticky=W)

        randomizeWidget = Button(simuFrame, text="Randomize", command=self.simu.randomize).grid(row=1, column=2, padx=4, pady=2)
        resetWidget = Button(simuFrame, text="Reset", command=self.simu.reset).grid(row=1, column=3, padx=4, pady=2)


        ####
        scalesFrame = Frame(topFrame, relief=FLAT, borderwidth=1)
        scalesFrame.grid(row=1, column=0, columnspan=2, padx=10, pady=10)
        #
        scalesLabel = Label(scalesFrame, text="Scales:").grid(row=0, column=0, sticky=W)


        self.tkr.kxWidget = Scale(scalesFrame, orient=VERTICAL, from_=2.01*3.14159265359, to=0.0, resolution=0.000001, label="kx", command=lambda str: self.setKx(str))
        self.tkr.kxWidget.set(self.simu.k.x)
        self.tkr.kxWidget.grid(row=1, column=0)

        self.tkr.kyWidget = Scale(scalesFrame, orient=VERTICAL, from_=2.01*3.14159265359, to=0.0, resolution=0.000001, label="ky", command=lambda str: self.setKy(str))
        self.tkr.kyWidget.set(self.simu.k.y)
        self.tkr.kyWidget.grid(row=1, column=1)


        JbxRatioWidget = Scale(scalesFrame, orient=VERTICAL, from_=10.0, to=-10.0, resolution=0.001, label="Jbx", command=lambda str: self.simu.setJbx(str))
        JbxRatioWidget.set(self.simu.Jbx)
        JbxRatioWidget.grid(row=1, column=2)

        JbyRatioWidget = Scale(scalesFrame, orient=VERTICAL, from_=10.0, to=-10.0, resolution=0.001, label="Jby", command=lambda str: self.simu.setJby(str))
        JbyRatioWidget.set(self.simu.Jby)
        JbyRatioWidget.grid(row=1, column=3)
        #


        ####
        scales2Frame = Frame(topFrame, relief=FLAT, borderwidth=1)
        scales2Frame.grid(row=2, column=0, columnspan=2, padx=10, pady=10)
        #
        meanFieldDownWidget = Scale(scales2Frame, orient=VERTICAL, from_=1.00, to=-1.00, resolution=0.001, label="MFD", command=lambda str: self.simu.setMFd(str))
        meanFieldDownWidget.set(self.simu.MFd)
        meanFieldDownWidget.grid(row=0, column=0)

        meanFieldUpWidget = Scale(scales2Frame, orient=VERTICAL, from_=1.00, to=-1.00, resolution=0.001, label="MFU", command=lambda str: self.simu.setMFu(str))
        meanFieldUpWidget.set(self.simu.MFu)
        meanFieldUpWidget.grid(row=0, column=1)

        tempWidget = Scale(scales2Frame, orient=VERTICAL, from_=1.0, to=0, resolution=0.001, label="kT", command=lambda str: self.simu.setTemp(str))
        tempWidget.set(self.simu.temp/self.simu.Ja)
        tempWidget.grid(row=0, column=2)

        DtWidget = Scale(scales2Frame, orient=VERTICAL, from_=self.simu.dtUpperLimit, to=0, label="dt", command=lambda str: self.simu.setDt(str))
        DtWidget.set(self.simu.dt*1000000.0)
        DtWidget.grid(row=0, column=3)
        #
            
        thread.start_new_thread(self.tkr.mainloop(),())
   
        
    def setKx(self,kx):
        self.k.x = float(kx)
               
        self.simu.k = self.k
        self.simu.reset()
  
    def setKy(self,ky):
        self.k.y = float(ky)
        
        self.simu.k = self.k
        self.simu.reset()


        
interface = Interface(nSpinsX, nSpinsY, stripeSpacingX, stripeSpacingY, Ja, Jbx, Jby, k, baseSigma, dt)


    






